//
//  MCTVToolbarView.h
//  MCApplication
//
//  Created by Ali Lalani on 1/10/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCApplicationDefines.h"
#import "MCTVToolbarButton.h"

typedef enum _MCTVToolbarBezelStyle {
    MCTVToolbarShinyGrayStyle		= 0, /* Visually left aligned */
    MCTVToolbarFlatGrayStyle		= 1, /* Visually left aligned */
} MCTVToolbarBezelStyle;

@interface MCTVToolbarView : NSView {
	NSFont *font;
	NSString *stringValue;

	NSString *leftStringValue;
	NSString *rightStringValue;

	BOOL drawRightBorder;
	BOOL drawLeftBorder;
	BOOL drawTopBorder;
	BOOL drawBottomBorder;
	
	NSColor *topBorderColor;
	NSColor *rightBorderColor;
	NSColor *leftBorderColor;
	NSColor *bottomBorderColor;
	
	NSTextAlignment stringValueAlignment;
	float leftStringValueMargin;
	float rightStringValueMargin;

	NSImageCell *background;
	NSImageCell *graphiteBackground;

	MCTVToolbarBezelStyle bezelStyle;
}
// Setup

// Removes existing subviews, then creates a icon only button for each passed in selector. If a selector is missing, no button is created. Enable selectors are optional. If you need to further configure a button (i.e tooltip), then get the button with firstButtonWithSelector method. If aMenu is valid, then a popup add button is added (in which case the add selector is not required).
- (void)configureAsIconToolbarWithTarget:(id)aTarget 
							 addSelector:(SEL)addSelector 
					   enableAddSelector:(SEL)enableAddSelector
								 addMenu:(NSMenu *)aMenu
						  deleteSelector:(SEL)delSelector
					enableDeleteSelector:(SEL)enableDeleteSelector
							editSelector:(SEL)editSelector
					  enableEditSelector:(SEL)enableEditSelector;

- (void)configureAsIconToolbarWithTarget:(id)aTarget 
							 addSelector:(SEL)addSelector 
					   enableAddSelector:(SEL)enableAddSelector
						  deleteSelector:(SEL)delSelector
					enableDeleteSelector:(SEL)enableDeleteSelector
							editSelector:(SEL)editSelector
					  enableEditSelector:(SEL)enableEditSelector;


- (void)configureAsIconToolbarWithTarget:(id)aTarget 
							 addSelector:(SEL)addSelector 
					   enableAddSelector:(SEL)enableAddSelector
						  deleteSelector:(SEL)delSelector
					enableDeleteSelector:(SEL)enableDeleteSelector;

- (void)configureAsIconToolbarWithTarget:(id)aTarget 
							 addSelector:(SEL)addSelector 
						  deleteSelector:(SEL)delSelector
							editSelector:(SEL)editSelector;

- (void)configureAsIconToolbarWithTarget:(id)aTarget 
							 addSelector:(SEL)addSelector 
						  deleteSelector:(SEL)delSelector;



- (MCTVToolbarButton *)addButtonWithType:(MCTVToolbarButtonType)aType
							 activeImage:(NSImage *)activeImage
						   inactiveImage:(NSImage *)inactiveImage
						   displayString:(NSString *)displayString;

// Returns the first button with aSelector. Theoretically, you could have multiple buttons with the same selector.
- (MCTVToolbarButton *)firstButtonWithSelector:(SEL)aSelector;

- (void)tile;
- (float)preferredWidth;
- (NSRect)drawableBounds; // takes into account the borders and gives you the area you can draw in

// Drawing
- (void)drawStringValueInRect:(NSRect)rect;
- (void)drawDualStringValueInRect:(NSRect)rect;

- (NSDictionary *)stringValueAttributes;

// Accessors
- (NSFont *)font;
- (void)setFont:(NSFont *)aFont;

- (NSString *)stringValue;
- (void)setStringValue:(NSString *)aStringValue;

- (BOOL)drawRightBorder;
- (void)setDrawRightBorder:(BOOL)flag;

- (BOOL)drawLeftBorder;
- (void)setDrawLeftBorder:(BOOL)flag;

- (BOOL)drawTopBorder;
- (void)setDrawTopBorder:(BOOL)flag;

- (BOOL)drawBottomBorder;
- (void)setDrawBottomBorder:(BOOL)flag;

- (void)setStringValueAlignment:(NSTextAlignment)align;
- (NSTextAlignment)stringValueAlignment;

- (float)leftStringValueMargin;
- (void)setLeftStringValueMargin:(float)aLeftStringValueMargin;

- (float)rightStringValueMargin;
- (void)setRightStringValueMargin:(float)aRightStringValueMargin;

- (NSString *)leftStringValue;
- (void)setLeftStringValue:(NSString *)aLeftStringValue;

- (NSString *)rightStringValue;
- (void)setRightStringValue:(NSString *)aRightStringValue;

- (NSImageCell *)background;
- (void)setBackground:(NSImageCell *)aBackground;

- (NSImageCell *)graphiteBackground;
- (void)setGraphiteBackground:(NSImageCell *)aGraphiteBackground;

- (MCTVToolbarBezelStyle)bezelStyle;
- (void)setBezelStyle:(MCTVToolbarBezelStyle)aBezelStyle;

- (NSColor *)topBorderColor;
- (void)setTopBorderColor:(NSColor *)aTopBorderColor;
- (NSColor *)rightBorderColor;
- (void)setRightBorderColor:(NSColor *)aRightBorderColor;
- (NSColor *)leftBorderColor;
- (void)setLeftBorderColor:(NSColor *)aLeftBorderColor;
- (NSColor *)bottomBorderColor;
- (void)setBottomBorderColor:(NSColor *)aBottomBorderColor;
@end
